/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.client.particle.SAO;

import com.dfdyz.epicacg.client.render.EpicACGRenderType;
import com.dfdyz.epicacg.client.render.pipeline.PostEffectPipelines;
import com.dfdyz.epicacg.utils.MathUtils;
import com.dfdyz.epicacg.utils.RenderUtils;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.client.model.ItemSkin;
import yesman.epicfight.api.client.model.ItemSkins;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class StarFlashParticle
extends Particle {
    private final Joint joint;
    private final TrailInfo trailInfo;
    private final StaticAnimation animation;
    private final LivingEntityPatch<?> entitypatch;
    private boolean animationEnd = false;
    private static RenderUtils.Quad quad1 = new RenderUtils.Quad(1.2f, 1.2f).rotate(Vec3f.X_AXIS, -90.0f).move(-0.58f, 0.0f, 0.0f).rotate(Vec3f.Y_AXIS, 30.0f).move(0.0f, 0.2f, 0.2f);
    private static RenderUtils.Quad quad2 = new RenderUtils.Quad(1.2f, 1.2f).rotate(Vec3f.X_AXIS, -90.0f).move(-0.58f, 0.0f, 0.0f).rotate(Vec3f.Y_AXIS, 150.0f).move(0.0f, 0.2f, 0.2f);
    float oAlpha;
    int frame = 0;
    int timer = 0;

    public StarFlashParticle(ClientLevel level, LivingEntityPatch<?> entitypatch, Joint joint, StaticAnimation animation, TrailInfo trailInfo) {
        super(level, 0.0, 0.0, 0.0);
        this.joint = joint;
        this.entitypatch = entitypatch;
        this.animation = animation;
        this.f_107219_ = false;
        this.trailInfo = trailInfo;
        this.f_107225_ = trailInfo.trailLifetime;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.oAlpha = this.f_107230_ = 1.0f;
        if (((LivingEntity)this.entitypatch.getOriginal()).m_6084_()) {
            Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
            this.m_107264_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        AnimationPlayer animPlayer = this.entitypatch.getAnimator().getPlayerFor((DynamicAnimation)this.animation);
        ++this.f_107224_;
        this.oAlpha = this.f_107230_;
        if (this.animationEnd) {
            this.f_107230_ -= 1.0f / (float)this.trailInfo.trailLifetime;
            if (this.f_107225_-- == 0) {
                this.m_107274_();
            }
        } else if (!((LivingEntity)this.entitypatch.getOriginal()).m_6084_() || this.animation != animPlayer.getAnimation().getRealAnimation() || animPlayer.getElapsedTime() > this.trailInfo.endTime) {
            this.animationEnd = true;
            this.f_107225_ = this.trailInfo.trailLifetime;
        }
        if (++this.timer > 2) {
            this.timer = 0;
            if (++this.frame >= this.trailInfo.interpolateCount) {
                this.frame = 0;
            }
        }
        if (((LivingEntity)this.entitypatch.getOriginal()).m_6084_()) {
            Vec3 pos = ((LivingEntity)this.entitypatch.getOriginal()).m_20182_();
            this.m_107264_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    private float getAlpha(float pt) {
        return Mth.m_14179_((float)pt, (float)this.oAlpha, (float)this.f_107230_);
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float pt) {
        if (!PostEffectPipelines.isActive() || !((LivingEntity)this.entitypatch.getOriginal()).m_6084_()) {
            return;
        }
        EpicACGRenderType.getBloomRenderTypeByTexture(this.trailInfo.texturePath).callPipeline();
        AnimationPlayer animPlayer = this.entitypatch.getAnimator().getPlayerFor((DynamicAnimation)this.animation);
        float elapsedTime = Mth.m_14179_((float)pt, (float)animPlayer.getPrevElapsedTime(), (float)animPlayer.getElapsedTime());
        if (!this.animationEnd && elapsedTime < this.trailInfo.startTime) {
            return;
        }
        Pose pose = this.entitypatch.getAnimator().getPose(pt);
        Vec3 pos = ((LivingEntity)this.entitypatch.getOriginal()).m_20318_(pt);
        OpenMatrix4f modelTf = OpenMatrix4f.createTranslation((float)((float)pos.f_82479_), (float)((float)pos.f_82480_), (float)((float)pos.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(this.entitypatch.getModelMatrix(pt)));
        OpenMatrix4f tf = this.entitypatch.getArmature().getBindedTransformFor(pose, this.joint).mulFront(modelTf);
        Vec3f particlePos = OpenMatrix4f.transform3v((OpenMatrix4f)tf, (Vec3f)new Vec3f(0.0f, 0.0f, -0.3f), (Vec3f)new Vec3f());
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        Vec3 camPos = camera.m_90583_();
        float x = particlePos.x - (float)camPos.m_7096_();
        float y = particlePos.y - (float)camPos.m_7098_();
        float z = particlePos.z - (float)camPos.m_7094_();
        Quaternionf camRot = camera.m_253121_();
        float alp = this.getAlpha(pt);
        float t_ = ((float)(this.f_107224_ % 10) + pt) / 9.0f;
        t_ = t_ <= 0.5f ? 4.0f * t_ - 1.0f : -4.0f * t_ + 3.0f;
        float sz = (7.5f + 1.0f * t_) * alp;
        t_ = ((float)(this.f_107224_ % 5) + pt) / 4.0f;
        t_ = t_ <= 0.5f ? 4.0f * t_ - 1.0f : -4.0f * t_ + 3.0f;
        Quaternionf rol = new Quaternionf(new AxisAngle4f(MathUtils.toDegrees(t_ * 2.5f), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)rol);
            vector3f.mul(sz);
            vector3f.add(0.0f, 0.0f, -0.2f);
            vector3f.rotate((Quaternionfc)camRot);
            vector3f.add(x, y, z);
        }
        float perFrame = 1.0f / (float)this.trailInfo.interpolateCount;
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = perFrame * (float)this.frame;
        float v1 = perFrame + perFrame * (float)this.frame;
        int j = 0xF000F0;
        vertexConsumer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, 1.0f).m_7421_(u0, v0).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, 1.0f).m_7421_(u0, v1).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, 1.0f).m_7421_(u1, v1).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, 1.0f).m_7421_(u1, v0).m_85969_(j).m_5752_();
    }

    public boolean shouldCull() {
        return false;
    }

    public ParticleRenderType m_7556_() {
        return EpicACGRenderType.getBloomRenderTypeByTexture(this.trailInfo.texturePath);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Provider(SpriteSet spriteSet) {
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            int eid = (int)Double.doubleToRawLongBits(x);
            int modid = (int)Double.doubleToRawLongBits(y);
            int animid = (int)Double.doubleToRawLongBits(z);
            int jointId = (int)Double.doubleToRawLongBits(xSpeed);
            int idx = (int)Double.doubleToRawLongBits(ySpeed);
            Entity entity = level.m_6815_(eid);
            if (entity != null) {
                ItemStack stack;
                ItemSkin itemSkin;
                LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class);
                StaticAnimation animation = AnimationManager.getInstance().byId(animid);
                Optional trailInfo = animation.getProperty((AnimationProperty)ClientAnimationProperties.TRAIL_EFFECT);
                TrailInfo result = (TrailInfo)((List)trailInfo.get()).get(idx);
                if (result.hand != null && (itemSkin = ItemSkins.getItemSkin((Item)(stack = ((LivingEntity)entitypatch.getOriginal()).m_21120_(result.hand)).m_41720_())) != null) {
                    result = itemSkin.trailInfo().overwrite(result);
                }
                if (entitypatch != null && animation != null && trailInfo.isPresent()) {
                    return new StarFlashParticle(level, entitypatch, entitypatch.getArmature().searchJointById(jointId), animation, result);
                }
            }
            return null;
        }
    }
}

